/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.ConvertAlignment;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneticCode;
import dr.evoxml.util.DataTypeUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class ConvertAlignmentParser
extends AbstractXMLObjectParser {
    public static final String CONVERT = "convert";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Alignment.class), new StringAttributeRule("dataType", "The type of sequence data", new String[]{"nucleotide", "amino acid", "codon", "binary", "hiddenCodon2", "hiddenCodon3", "hiddenCodon4", "hiddenCodon5"}, false)};

    @Override
    public String getParserName() {
        return CONVERT;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Alignment alignment = (Alignment)xMLObject.getChild(Alignment.class);
        DataType dataType = DataTypeUtils.getDataType(xMLObject);
        GeneticCode geneticCode = GeneticCode.UNIVERSAL;
        if (dataType instanceof Codons) {
            geneticCode = ((Codons)dataType).getGeneticCode();
        }
        ConvertAlignment convertAlignment = new ConvertAlignment(dataType, geneticCode, alignment);
        Logger.getLogger("dr.evoxml").info("Converted alignment, '" + xMLObject.getId() + "', from " + alignment.getDataType().getDescription() + " to " + dataType.getDescription());
        return convertAlignment;
    }

    @Override
    public String getParserDescription() {
        return "Converts an alignment to the given data type.";
    }

    @Override
    public Class getReturnType() {
        return Alignment.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

