/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.Integral;
import dr.math.MathUtils;
import dr.math.UnivariateFunction;

public class MonteCarloIntegral
implements Integral {
    private int sampleSize;

    public MonteCarloIntegral(int n) {
        this.sampleSize = n;
    }

    @Override
    public double integrate(UnivariateFunction univariateFunction, double d, double d2) {
        double d3 = 0.0;
        double d4 = d2 - d;
        for (int i = 1; i <= this.sampleSize; ++i) {
            d3 += univariateFunction.evaluate(MathUtils.nextDouble() * d4 + d);
        }
        return d3 *= d4 / (double)this.sampleSize;
    }
}

