/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.List;
import jebl.evolution.graphs.Edge;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.SplitSystem;
import jebl.evolution.trees.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitUtils {
    private SplitUtils() {
    }

    public static SplitSystem getSplits(Tree tree) {
        return SplitUtils.getSplits(new ArrayList<Taxon>(tree.getTaxa()), tree);
    }

    public static SplitSystem getSplits(List<Taxon> taxa, Tree tree) {
        int size = tree.getInternalEdges().size();
        SplitSystem splitSystem = new SplitSystem(taxa, size);
        boolean[][] splits = splitSystem.getSplitVector();
        int j = 0;
        for (Edge edge : tree.getInternalEdges()) {
            SplitUtils.getSplit(taxa, tree, edge, splits[j]);
            ++j;
        }
        return splitSystem;
    }

    public static void getSplit(List<Taxon> taxa, Tree tree, Edge edge, boolean[] split) {
        for (int i = 0; i < split.length; ++i) {
            split[i] = false;
        }
        Node[] nodes = tree.getNodes(edge);
        SplitUtils.markNode(taxa, tree, nodes[0], nodes[1], split);
        if (!split[0]) {
            for (int i = 0; i < split.length; ++i) {
                split[i] = !split[i];
            }
        }
    }

    public static boolean isSame(boolean[] s1, boolean[] s2) {
        boolean reverse;
        boolean bl = reverse = s1[0] != s2[0];
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Splits must be of the same length!");
        }
        for (int i = 0; i < s1.length; ++i) {
            if (!(reverse ? s1[i] == s2[i] : s1[i] != s2[i])) continue;
            return false;
        }
        return true;
    }

    static void markNode(List<Taxon> taxa, Tree tree, Node node, Node parent, boolean[] split) {
        if (tree.isExternal(node)) {
            Taxon taxon = tree.getTaxon(node);
            int index = taxa.indexOf(taxon);
            if (index < 0) {
                throw new IllegalArgumentException("INCOMPATIBLE IDENTIFIER (" + taxon + ")");
            }
            split[index] = true;
        } else {
            for (Node child : tree.getAdjacencies(node)) {
                if (child == parent) continue;
                SplitUtils.markNode(taxa, tree, child, node, split);
            }
        }
    }
}

